<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Firmar Documento PDF</title>
  <link rel="stylesheet" href="assets/css/style.css" />
  <style>
    body { font-family: sans-serif; margin: 0; padding: 1rem; background: #f8f9fa; }
    #pdfViewer canvas { display: block; margin: 0 auto 1rem auto; width: 100% !important; height: auto !important; max-width: 100%; }
    #pdfViewer { width: 100%; max-height: 70vh; overflow-y: scroll; border: 1px solid #ccc; margin-bottom: 1rem; background: white; }
    .btn { padding: 10px 15px; margin: 5px; border: none; border-radius: 4px; cursor: pointer; }
    .btn-primary { background: var(--primary-color); color: white; }
    .btn-secondary { background: var(--secondary-color); color: white; }
    .signature-pad { border: 2px dashed rgba(255, 255, 255, 0.3); border-radius: 8px; background: rgba(255, 255, 255, 0.05); cursor: crosshair; }
    .signature-preview { margin-top: 20px; padding: 15px; background: rgba(0, 0, 0, 0.2); border-radius: 8px; }
  </style>
</head>
<body>
  <h2>Visualizar y Firmar Documento PDF</h2>
  
  <!-- Input para cargar el archivo PDF -->
  <input type="file" id="fileInput" accept="application/pdf" />
  
  <!-- Visualizador del PDF -->
  <div id="pdfViewer"></div>

  <!-- Canvas para la firma -->
  <h4>Dibuja tu firma:</h4>
  <canvas id="signatureCanvas" class="signature-pad"></canvas><br>
  <button class="btn btn-secondary" onclick="clearSignature()">Limpiar</button>
  <button class="btn btn-primary" onclick="insertSignature()">Insertar Firma</button>

  <div class="signature-preview" id="signature-preview"></div>

  <script src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/2.14.305/pdf.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/2.14.305/pdf.worker.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/pdf-lib@1.17.1/dist/pdf-lib.min.js"></script>

  <script>
    const fileInput = document.getElementById('fileInput');
    const pdfViewer = document.getElementById('pdfViewer');
    const signatureCanvas = document.getElementById("signatureCanvas");
    const sigCtx = signatureCanvas.getContext("2d");

    let pdfBytes, pdfDocOriginal;

    fileInput.addEventListener('change', async (e) => {
      const file = e.target.files[0];
      if (file.type !== 'application/pdf') {
        alert('Solo se permiten archivos PDF');
        return;
      }
      pdfBytes = await file.arrayBuffer();
      renderPDF(pdfBytes);
    });

    async function renderPDF(data) {
      const loadingTask = pdfjsLib.getDocument({ data });
      const pdf = await loadingTask.promise;
      pdfDocOriginal = pdf;

      pdfViewer.innerHTML = '';
      for (let pageNum = 1; pageNum <= pdf.numPages; pageNum++) {
        const page = await pdf.getPage(pageNum);
        const scale = 3; // Aumentar la resolución
        const viewport = page.getViewport({ scale });
        const canvas = document.createElement('canvas');
        const context = canvas.getContext('2d');
        canvas.height = viewport.height;
        canvas.width = viewport.width;
        await page.render({ canvasContext: context, viewport }).promise;
        pdfViewer.appendChild(canvas);
      }
    }

    // Firma
    let isDrawing = false;

    function resizeCanvas() {
      signatureCanvas.width = signatureCanvas.offsetWidth;
      signatureCanvas.height = 200;
    }
    resizeCanvas();
    window.addEventListener("resize", resizeCanvas);

    signatureCanvas.addEventListener("mousedown", e => {
      isDrawing = true;
      sigCtx.beginPath();
      sigCtx.moveTo(e.offsetX, e.offsetY);
    });
    signatureCanvas.addEventListener("mousemove", e => {
      if (!isDrawing) return;
      sigCtx.lineTo(e.offsetX, e.offsetY);
      sigCtx.stroke();
    });
    signatureCanvas.addEventListener("mouseup", () => isDrawing = false);
    signatureCanvas.addEventListener("mouseleave", () => isDrawing = false);

    function clearSignature() {
      sigCtx.clearRect(0, 0, signatureCanvas.width, signatureCanvas.height);
      document.getElementById('signature-preview').innerHTML = '';
    }

    async function insertSignature() {
      if (!pdfBytes) return alert("Primero carga un PDF");

      const signatureImage = signatureCanvas.toDataURL("image/png");
      const pdfDoc = await PDFLib.PDFDocument.load(pdfBytes);
      const pages = pdfDoc.getPages();
      const firstPage = pages[0];

      const pngImage = await pdfDoc.embedPng(signatureImage);
      const { width, height } = pngImage.scale(0.5);

      firstPage.drawImage(pngImage, {
        x: 50,
        y: 50,
        width,
        height
      });

      const modifiedPdfBytes = await pdfDoc.save();
      const blob = new Blob([modifiedPdfBytes], { type: 'application/pdf' });
      const link = document.createElement('a');
      link.href = URL.createObjectURL(blob);
      link.download = 'documento_firmado.pdf';
      link.click();

      // Mostrar firma
      document.getElementById('signature-preview').innerHTML = 
        `<img src="${signatureImage}" style="max-width: 200px; border: 1px solid #ccc; border-radius: 5px;">`;
    }
  </script>
</body>
</html>
