<?php include 'config.php'; ?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sistema de Firma Digital</title>
    <link rel="icon" href="public/images/favicon.png" type="image/png">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <div class="container">
        <header>
        <img src="public/images/banner.png" alt="Banner" class="banner-image">
            <h1 class="neon-text">Firma Digital</h1>
            <p class="subtitle">Sube tu documento y obtén firmas electrónicas</p>
        </header>

        <div class="upload-section glassmorphism">
            <h2>Subir Nuevo Documento</h2>
            <form action="upload.php" method="post" enctype="multipart/form-data">
                <div class="form-group">
                    <label for="document_name">Nombre del Documento</label>
                    <input type="text" id="document_name" name="document_name" required>
                </div>
                <div class="form-group">
                    <label for="client_email">Email del Cliente</label>
                    <input type="email" id="client_email" name="client_email" required>
                </div>
                <div class="form-group">
                    <label for="pdf_file">Seleccionar PDF</label>
                    <input type="file" id="pdf_file" name="pdf_file" accept=".pdf" required>
                </div>
                <button type="submit" class="btn-gradient">Subir Documento</button>
            </form>
        </div>

        <div class="documents-list glassmorphism">
            <h2>Documentos Pendientes</h2>
            <div class="document-grid">
                <?php
                $stmt = $db->query("SELECT * FROM documents WHERE status = 'pending'");
                while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                    echo '<div class="document-card">';
                    echo '<h3>' . htmlspecialchars($row['document_name']) . '</h3>';
                    echo '<p>Cliente: ' . htmlspecialchars($row['client_email']) . '</p>';
                    echo '<a href="sign.php?id=' . $row['id'] . '" class="btn-sign">Firmar Documento</a>';
                    echo '</div>';
                }
                ?>
            </div>
        </div>
    </div>

    <footer>
        <p>La casa del app &copy; <?php echo date('Y'); ?></p>
    </footer>

    <script src="assets/js/script.js"></script>
</body>
</html>