<?php
include 'config.php';

$docId = $_GET['id'] ?? 0;
$stmt = $db->prepare("SELECT * FROM documents WHERE id = ?");
$stmt->execute([$docId]);
$document = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$document) {
    die("Documento no encontrado.");
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Firmar Documento</title>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/style.css">

    <!-- Estilos para PDF.js y responsive -->
    <style>
        .pdf-container {
            width: 100%;
            height: 80vh;
            overflow: auto;
            background: #000;
            border-radius: 10px;
        }

        canvas {
            display: block;
            margin: 0 auto;
            width: 100% !important;
            height: auto !important;
        }

        @media (max-width: 600px) {
            .pdf-container {
                height: 70vh;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <header>
            <h1 class="neon-text">Firmar Documento</h1>
            <p class="subtitle"><?php echo htmlspecialchars($document['document_name']); ?></p>
        </header>

        <div class="sign-container">
            <!-- Visor PDF usando PDF.js -->
            <div class="pdf-container glassmorphism">
                <canvas id="pdf-render"></canvas>
            </div>

            <div class="signature-panel glassmorphism">
                <h2>Agregar Firma</h2>
                <div class="signature-area">
                    <canvas id="signature-pad" width="400" height="200"></canvas>
                </div>
                <div class="signature-actions">
                    <button id="clear-signature" class="btn-clear">Limpiar</button>
                    <button id="save-signature" class="btn-gradient" data-docid="<?php echo $docId; ?>">Guardar Firma</button>
                </div>
                <div class="signature-preview">
                    <p>Vista previa de la firma:</p>
                    <div id="signature-preview"></div>
                </div>
            </div>
        </div>
    </div>

    <!-- PDF.js -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/3.11.174/pdf.min.js"></script>
    <script>
        const url = "<?php echo htmlspecialchars($document['file_path']); ?>";

        const pdfjsLib = window['pdfjs-dist/build/pdf'];
        pdfjsLib.GlobalWorkerOptions.workerSrc = 'https://cdnjs.cloudflare.com/ajax/libs/pdf.js/3.11.174/pdf.worker.min.js';

        const loadingTask = pdfjsLib.getDocument(url);
        loadingTask.promise.then(function(pdf) {
            pdf.getPage(1).then(function(page) {
                const scale = 1.5;
                const viewport = page.getViewport({ scale: scale });
                const canvas = document.getElementById('pdf-render');
                const context = canvas.getContext('2d');
                canvas.height = viewport.height;
                canvas.width = viewport.width;

                const renderContext = {
                    canvasContext: context,
                    viewport: viewport
                };
                page.render(renderContext);
            });
        });
    </script>

    <!-- Firma -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/signature_pad/1.5.3/signature_pad.min.js"></script>
    <script src="assets/js/script.js"></script>


</body>
</html>
