<?php
include 'config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $documentName = $_POST['document_name'];
    $clientEmail = $_POST['client_email'];
    $clientPhone = $_POST['client_phone']; // Añade esto al inicio
    // Validar y subir archivo
    $fileName = basename($_FILES['pdf_file']['name']);
    $targetFile = UPLOAD_DIR . uniqid() . '_' . $fileName;
    $fileType = strtolower(pathinfo($targetFile, PATHINFO_EXTENSION));

    // Verificar que es un PDF
    if ($fileType != "pdf") {
        die("Solo se permiten archivos PDF.");
    }

    if (move_uploaded_file($_FILES['pdf_file']['tmp_name'], $targetFile)) {
        // Insertar en base de datos
        $stmt = $db->prepare("INSERT INTO documents (document_name, client_email, client_phone, file_path, status) 
                     VALUES (:name, :email, :phone, :path, 'pending')");
            $stmt->execute([
                ':name' => $documentName,
                ':email' => $clientEmail,
                ':phone' => $clientPhone, // Nuevo campo
                ':path' => $targetFile
            ]);

        // Enviar email al cliente (simplificado)
        $signLink = "http://" . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) . "/sign.php?id=" . $db->lastInsertId();
        $subject = "Por favor firme el documento: $documentName";
        $message = "Haga clic en el siguiente enlace para firmar el documento: $signLink";
        mail($clientEmail, $subject, $message);

        header("Location: index.php?success=1");
    } else {
        die("Error al subir el archivo.");
    }
}
?>